* THIS DO-FILE IS FOR THE EUROPEAN REGIONAL ANALYSIS
* IT CREATES THE OUTPUT FOR TABLE 5 AND APPENDIX TABLES D1 & B5


use data\EuropeanRegions2.dta, clear

 
*______________________________
* Create sample (such that all regressions will have same number of observations

keep if facntr==1  //only respondents whose father did not immigrate
keep if mocntr==1  //only respondents whose father did not immigrate
keep if citizen==1 //only those who indicated that they are citizens
drop if education==.
drop if rlgdnm==.
drop if rlgdgr==.
drop if domicil==.
drop if monastic==.
drop if pop_densit500ad ==.


*____________________________________________
*	Table 5: Cousin Marriage and Political Participation in Regions of Europe
local v Ln_FirstCousin
local a ageb_sqrt ageb female
local b rugged dist_coast caloricsui abs_latitude
local c prec temp elevation river_lake rye_rain oat_rain
local d roman_road
local e monastic
local f rlgdgr i.rlgdnm
local g i.education 
local h i.domicil pop_densit500ad

local x vote
eststo: areg `x' `v' `a' 								i.essround, absorb(cntry) cluster(region_name)
eststo: areg `x' `v' `a' `b' 							i.essround, absorb(cntry) cluster(region_name)
eststo: areg `x' `v' `a' `b' `c' 						i.essround, absorb(cntry) cluster(region_name)
eststo: areg `x' `v' `a' `b' `d' 						i.essround, absorb(cntry) cluster(region_name)
eststo: areg `x' `v' `a' `b' `e' `f' 					i.essround, absorb(cntry) cluster(region_name)
eststo: areg `x' `v' `a' `b' `g' 						i.essround, absorb(cntry) cluster(region_name)
eststo: areg `x' `v' `a' `b' `h'						i.essround, absorb(cntry) cluster(region_name)
eststo: areg `x' `v' `a' `b' `c' `d' `e' `f' `g' `h'	i.essround, absorb(cntry) cluster(region_name)
esttab using tables\Table6_Vote.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear

*____________________________________________
*	Table D1:	Cousin Marriage and Political Participation in Regions of Europe with spatial Conley standard errors

*create numeric countyr code
sort cntry
by cntry: gen country_id = 1 if _n==1
replace country_id = sum(country_id)
replace country_id = . if missing(cntry)

local x vote
local dist 2500
eststo: acreg `x' `v' `a'									, pfe1(essround) pfe2(country_id) spatial latitude(latitude) longitude(longitude) dist(`dist') bartlett
eststo: acreg `x' `v' `a' `b'								, pfe1(essround) pfe2(country_id) spatial latitude(latitude) longitude(longitude) dist(`dist') bartlett
eststo: acreg `x' `v' `a' `b' `c'							, pfe1(essround) pfe2(country_id) spatial latitude(latitude) longitude(longitude) dist(`dist') bartlett
eststo: acreg `x' `v' `a' `b' `d'							, pfe1(essround) pfe2(country_id) spatial latitude(latitude) longitude(longitude) dist(`dist') bartlett
eststo: xi: acreg `x' `v' `a' `b' `e' `f'						, pfe1(essround) pfe2(country_id) spatial latitude(latitude) longitude(longitude) dist(`dist') bartlett
eststo: xi: acreg `x' `v' `a' `b' `g'							, pfe1(essround) pfe2(country_id) spatial latitude(latitude) longitude(longitude) dist(`dist') bartlett
eststo: xi: acreg `x' `v' `a' `b' `h'							, pfe1(essround) pfe2(country_id) spatial latitude(latitude) longitude(longitude) dist(`dist') bartlett
eststo: xi: acreg `x' `v' `a' `b' `c' `d' `e' `f' `g' `h'		, pfe1(essround) pfe2(country_id) spatial latitude(latitude) longitude(longitude) dist(`dist') bartlett
esttab using tables\TableD1_Conley_`dist'.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear


*___________________________________________
*	Table B5:	European regional-level Church exposure and cousin-marriage practices 
clear all
use data\EuropeanRegions2.dta

preserve
collapse carolingian_ratio ChurchExp rugged dist_coast caloricsui abs_latitude FirstCousin pop_densit500ad  roman_road rye_rain oat_rain prec temp irg_po elevation river_lake, by(cntry region_name)

gen Ln_FirstCousin = ln(FirstCousin)

keep if cntry=="IT" | cntry=="ES" | cntry=="FR" | cntry=="TR"

local a rugged dist_coast caloricsui
local b rugged dist_coast caloricsui abs_latitude

local x Ln_FirstCousin
local v ChurchExp
*Panel 1: Church Exposure & Cousin-Marriage______________________________
eststo: areg `x' `v' , absorb(cntry) r
eststo: areg `x' `v' `a', absorb(cntry) r
eststo: areg `x' `v' `b', absorb(cntry) r
eststo: areg `x' `v' `a' prec temp elevation river_lake rye_rain oat_rain irg_po, absorb(cntry) r
eststo: areg `x' `v' `a' roman_road , absorb(cntry) r
eststo: areg `x' `v' `a' pop_densit500ad , absorb(cntry) r
eststo: areg `x' `v' `a' roman_road pop_densit500ad  roman_road rye_rain oat_rain prec temp irg_po elevation river_lake, absorb(cntry) cluster(region_name)
esttab using tables\TableB5_Panel_1_ChurchExposure.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear

local x Ln_FirstCousin
local v carolingian_ratio
*Panel 2: Carolingian Exposure & Cousin-Marriage______________________________
eststo: areg `x' `v' , absorb(cntry) r
eststo: areg `x' `v' `a', absorb(cntry) r
eststo: areg `x' `v' `b', absorb(cntry) r
eststo: areg `x' `v' `a' prec temp elevation river_lake rye_rain oat_rain irg_po, absorb(cntry) r
eststo: areg `x' `v' `a' roman_road , absorb(cntry) r
eststo: areg `x' `v' `a' pop_densit500ad , absorb(cntry) r
eststo: areg `x' `v' `a' roman_road pop_densit500ad  roman_road rye_rain oat_rain prec temp irg_po elevation river_lake, absorb(cntry) cluster(region_name)
esttab using tables\TableB5_Panel_2_Carolingian.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore

